﻿Imports System.IO
Imports System.Reflection
Imports Amyuni.PDFCreator
Imports System.Text

Public Class Form1
    Const LicenseTo = "Amyuni Technologies Evaluation"
    Const ActivationCode = "07EFCDAB01000100DF3C224F154AFE934F6EBA2A0373BD6FA53818825560ED67F2C03F968D87456095BD4825B29C4144E6BC2155FE63"

    '/////////////////////////////////////////////////////////////////////////////////////
    'This code snippet illustrates how to enumerate through the contents of a PDF document 
    'and change the text values of all acField objects
    '/////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnLoopThroughObjects_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnLoopThroughObjects.Click

        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()

        'set license key This is needed only with licensed version
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        'get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\CreateTextObject.pdf"

        Try
            'need to create a document object
            Using doc As New IacDocument(Nothing)
                Try
                    Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)
                    doc.Open(fs, "")

                    'Declare ArrayList and fill it with all of the objects in the 
                    'current PDF document

                    'need to get total pages
                    Dim pageCount As Integer = doc.PageCount

                    For i As Integer = 1 To pageCount
                        'set current page:
                        doc.CurrentPage = doc.GetPage(i)
                        Dim arList As ArrayList = DirectCast(doc.GetPage(i).Attribute("Objects").Value, ArrayList)

                        'temp counter
                        Dim intCounter As Integer = 1

                        For Each obj As IacObject In arList
                            'you can access all properties of each object
                            Dim attr As IacAttribute = obj.Attribute("ObjectType")

                            'You have access to object
                            'here you are checking if it is a field object
                            If CInt(attr.Value) = CInt(IacObjectType.acObjectTypeField) Then
                                obj.Attribute("Value").Value = "Object " & intCounter
                                obj.Attribute("TextFont").Value = "Arial, 16, 700, 0, 0"
                                'MessageBox.Show(obj.Attribute("Text").Value);
                                obj.Attribute("TextColor").Value = &HFF8811
                            End If

                            'MessageBox.Show(intCounter.ToString());
                            intCounter += 1
                        Next
                    Next

                    'need to open a file stream to save new PDF document
                    'save doc to new file
                    Dim fs2 As New FileStream(requiredPath & "\Resulting_Docs\LoopObjects_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)
                    doc.Save(fs2, IacFileSaveOption.acFileSaveView)
                    fs2.Close()

                Catch ev As Exception
                    MessageBox.Show(ev.Message)

                End Try

            End Using
        Catch ex As Exception
            MessageBox.Show(ex.Message.ToString())
        End Try

        'end and cleanup
        'this should only be done once when your app terminates
        acPDFCreatorLib.Terminate()

        ListBox1.Items.Add("LoopObjects_resulting.pdf ..... created")
    End Sub


    '/////////////////////////////////////////////////////////////////////////////////////
    'This code snippet illustrates how to create a new PDF document
    '/////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnCreatePDFDocument_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnCreatePDFDocument.Click

        Try
            acPDFCreatorLib.Initialize()
            acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

            Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

            Dim doc As New IacDocument(Nothing)
            Dim page As IacPage

            page = doc.GetPage(1)

            ' switch to design mode before adding objects to the document
            doc.ReportState = IacReportState.acReportStateDesign

            'Create a logo and place it at the top of the page
            With page.CreateObject(IacObjectType.acObjectTypePicture, "acObjectTypePicture")
                ' position the Image
                .AttributeByName("Left").Value = 0
                .AttributeByName("Top").Value = 0
                .AttributeByName("Right").Value = 1000
                .AttributeByName("Bottom").Value = 1000
                .AttributeByName("FileName").Value = requiredPath & "Source_Docs\\amyuni_logo.bmp"
            End With


            'Create a text and place it near the logo
            With page.CreateObject(IacObjectType.acObjectTypeText, "acObjectTypeText")
                ' position the Image
                .AttributeByName("Left").Value = 1000
                .AttributeByName("Top").Value = 0
                .AttributeByName("Right").Value = 3250
                .AttributeByName("Bottom").Value = 500
                .AttributeByName("BackColor").Value = 192
                .AttributeByName("Text").Value = "Amyuni Technologies"
            End With


            'Create a table object
            Dim rows As Integer
            Dim cols As Integer
            rows = 10 : cols = 5

            'This creates a Table object
            With page.CreateObject(IacObjectType.acObjectTypeTable, "acTypeTable")

                ' position table
                .AttributeByName("Top").Value = 1000
                .AttributeByName("Left").Value = 1000
                .AttributeByName("Right").Value = 9000
                .AttributeByName("Bottom").Value = 4000

                'Create rows and columns
                .AttributeByName("Rows").Value = rows
                .AttributeByName("Columns").Value = cols


                Dim k As Integer
                Dim l As Integer
                Dim row As Integer
                Dim col As Integer

                'This will create rows and columns
                For k = 1 To rows
                    row = k.ToString.Trim
                    For l = 1 To cols
                        col = l.ToString.Trim

                        'Access the cell obejcts
                        With doc.ObjectByName("acTypeTable.Cells[" & row & "," & col & "]")
                            .AttributeByName("HorzBorders").Value = 3
                            .AttributeByName("VertBorders").Value = 3
                            .AttributeByName("BorderWidth").Value = 1
                            .AttributeByName("Font").Value = "Arial,8"
                            .AttributeByName("HorzAlign").Value = 2
                            .AttributeByName("Text").Value = "[" & row & "," & col & "]"

                            'Can change the backcolor of a cell
                            If (l = 3) Then
                                .AttributeByName("BackColor").Value = "AAAAAA"
                            End If

                        End With
                    Next l
                Next k

            End With


            ' switch to run mode after objects to the document
            doc.ReportState = IacReportState.acReportStateRun


            ''Create new stream object
            Dim fileWrite As Stream = File.OpenWrite(requiredPath & "Resulting_Docs\\CreatePDFDocument_resulting.pdf")

            ''Save stream
            doc.Save(fileWrite, IacFileSaveOption.acFileSaveView)
            fileWrite.Close()

            ListBox1.Items.Add("CreatePDFDocument_resulting.pdf ...... created")


        Catch
        Finally
            'Clean Up
            acPDFCreatorLib.Terminate()
        End Try
    End Sub

    '/////////////////////////////////////////////////////////////////////////////////////
    ' This code snippet illustrates how to add an acObjectTypeText object to a PDF document
    '/////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnCreateObject_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnCreateObject.Click
        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()

        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\CreateTextObject.pdf"


        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)


        'need to create a document object
        Using pdfDoc As New IacDocument(Nothing)
            pdfDoc.Open(fs, "")

            'put component in design mode
            pdfDoc.ReportState = IacReportState.acReportStateDesign


            'create an acText object on Page 1
            Using oText As IacObject = pdfDoc.GetPage(1).CreateObject(IacObjectType.acObjectTypeText, "acText")
                pdfDoc.CurrentPage = pdfDoc.GetPage(1)

                oText.AttributeByName("left").Value = 1500
                oText.AttributeByName("Top").Value = 1000
                oText.AttributeByName("Right").Value = 8000
                oText.AttributeByName("Bottom").Value = 500
                oText.AttributeByName("TextAngle").Value = 900
                oText.AttributeByName("Text").Value = "Hello World"
                oText.AttributeByName("TextFont").Value = "Arial, 18, 700, 0, 0"
                oText.AttributeByName("TextColor").Value = &HFAEBD7
            End Using



            'need to open a file stream to save new PDF document
            'save doc to new file
            Dim fs2 As New FileStream(requiredPath & "\Resulting_Docs\CreateTextObject_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)
            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView)

            fs2.Close()
        End Using
        'end and cleanup
        'this should only be done once
        'when application ends
        acPDFCreatorLib.Terminate()

        ListBox1.Items.Add("CreateTextObject_resulting.pdf.... created")

    End Sub


    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'This code snippet illustrates how enumerate through a document and change the attributes of an acObjectTypeText object
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnAddText_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnAddText.Click
        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()

        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\objects.pdf"

        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

        Dim pdfDoc As New IacDocument(Nothing)

        pdfDoc.Open(fs, "")
        Try
            'Declare ArrayList and fill it with all of the objects in the 
            'current PDF document
            Dim arList As ArrayList = DirectCast(pdfDoc.GetPage(1).AttributeByName("Objects").Value, ArrayList)

            'temp counter
            Dim intCounter As Integer = 1


            For Each obj As IacObject In arList
                'you can access all properties of each object
                Dim attr As IacAttribute = obj.Attribute("ObjectType")

                'Check if it an text objects
                If CInt(attr.Value) = CInt(IacObjectType.acObjectTypeText) Then
                    'change the backcolor
                    obj.Attribute("BackColor").Value = 192

                    obj.Attribute("Text").Value = "Object: " & intCounter
                    obj.Attribute("TextFont").Value = "Arial, 16, 700, 0, 0"
                    obj.Attribute("TextColor").Value = &HFF8811

                    intCounter += 1

                End If
            Next


            'Save PDF File
            'save doc to new file
            Dim fs2 As New FileStream(requiredPath & "\Resulting_Docs\AddText_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)
            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView)
            fs2.Close()


            'end and cleanup
            'this should only be done once
            acPDFCreatorLib.Terminate()


            ListBox1.Items.Add("AddText_resulting.pdf..........created")
        Catch ev As Exception
            MessageBox.Show(ev.Message)
        End Try
    End Sub
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The GetObjectXY function returns a pointer to the object located at (X, Y) on the current page.
    'X position in twips
    'Y position in twips
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnGetObjectXy_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnGetObjectXy.Click
        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\objects.pdf"


        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

        'need to create a document object
        Using doc As New IacDocument(Nothing)
            'open doc object with filestream
            doc.Open(fs, "")

            Try
                'Get object my its XP position
                '1440 Twips/Inch
                '25.4 MM/Inch
                '56.7 Twips/MM 
                Using oText As IacObject = doc.GetPage(1).ObjectByXY(1590, 1700)
                    'Write value to Listbox
                    ListBox1.Items.Clear()

                    ListBox1.Items.Add("Found this:  " & oText.Attribute("Text").Value.ToString())

                End Using
            Catch ex As Exception
                MessageBox.Show(ex.Message)


            End Try
        End Using

        'end and cleanup
        'this should only be done once
        acPDFCreatorLib.Terminate()
    End Sub




    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'This code snippet illustrates how to insert an image object into a PDF document 
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnEmbedImage_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnEmbedImage.Click

        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()

        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        'need to create a document object
        Using doc As New IacDocument(Nothing)

            'put component in design mode
            doc.ReportState = IacReportState.acReportStateDesign

            'create object on Page 1
            Using oTypePicture As IacObject = doc.GetPage(1).CreateObject(IacObjectType.acObjectTypePicture, "acObjectTypePicture")
                oTypePicture.AttributeByName("Left").Value = 2000
                oTypePicture.AttributeByName("Top").Value = 2000
                ' oTypePicture.AttributeByName("Right").Value = page.Attribute("Width").Value;
                ' oTypePicture.AttributeByName("Bottom").Value = page.Attribute("Length").Value;
                oTypePicture.AttributeByName("Right").Value = 4000
                oTypePicture.AttributeByName("Bottom").Value = 4000


                oTypePicture.AttributeByName("FileName").Value = requiredPath & "Source_Docs\amyuni_logo.bmp"
            End Using

            'need to open a file stream to save new PDF document
            Dim strFilePathAndName As String = requiredPath & "\Resulting_Docs\EmbedImage_resulting.pdf"

            Dim fs As New FileStream(strFilePathAndName, FileMode.Create, FileAccess.Write, FileShare.Write)
            doc.Save(fs, IacFileSaveOption.acFileSaveView)

            fs.Close()
        End Using
        'end and cleanup
        'this should only be done once
        acPDFCreatorLib.Terminate()

        ListBox1.Items.Add("EmbedImage_resulting.pdf  .......   created")

    End Sub



    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ' The GetObjectsInRectangle method gets all the objects that are in the specified rectangle. 
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnGetObjRect_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnGetObjRect.Click
        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()

        'set license key This is needed only with licensed version
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\CreateTextObject.pdf"

        Try

            'need to create a document object
            Using doc As New IacDocument(Nothing)
                Try
                    'need to open a file stream 
                    Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)
                    doc.Open(fs, "")
                    doc.OptimizeDocument(1)

                    'Gets an array of objects in a rectangle
                    'Gets an array of objects in a rectangle
                    Dim objects As Object() = DirectCast(doc.GetObjectsInRectangle(100, 100, 10000, 10000, IacGetRectObjectsConstants.acGetRectObjectsInMainDocument), Object())

                    'found objects
                    If objects.Length <> 0 Then
                        For i As Integer = 0 To objects.Length - 1
                            Dim acObject As IacObject = DirectCast(objects(i), IacObject)
                            If acObject IsNot Nothing Then
                                'types of objects found  
                                MessageBox.Show(acObject.Attribute("ObjectType").Value.ToString())
                            End If
                        Next


                    End If
                Catch ev As Exception
                    MessageBox.Show(ev.Message)

                End Try

            End Using
        Catch ev As Exception
            MessageBox.Show(ev.Message)
        End Try
    End Sub




    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The ReachText function reaches a text object having a specified text and font attributes. This function searches the
    'document for the first object containing the specified text and makes that object visible.
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnSearchText_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnSearchText.Click
        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()


        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\objects.pdf"


        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

        'need to create a document object
        Using doc As New IacDocument(Nothing)
            'open doc object with filestream
            doc.Open(fs, "")

            '   'No optimization 0
            '   'Line optimization (Recommended) 1
            '   'Paragraph optimization 2
            '                

            doc.OptimizeDocument(1)

            Try
                ' Search for text		
                Dim strFindText As String = doc.ReachText(IacReachTextOption.acReachTextOptionStartNoCase, "1", "", 0, False, False)

                doc.ReportState = IacReportState.acReportStateDesign

                ' Check if text is found
                If strFindText <> "" Then

                    ' Replace it with a new text
                    Dim acObject As IacObject = doc.ObjectByName(strFindText)

                    If acObject IsNot Nothing Then
                        'Found object now change the value
                        acObject.AttributeByName("Text").Value = "Hello"

                    End If
                End If

                'need to open a file stream to save new PDF document
                'save doc to new file
                Dim fs2 As New FileStream(requiredPath & "\Resulting_Docs\Search_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)
                doc.Save(fs2, IacFileSaveOption.acFileSaveView)

                fs2.Close()
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try



            ListBox1.Items.Add("Search_resulting.pdf ........ created")
        End Using

        'end and cleanup
        'this should only be done once
        acPDFCreatorLib.Terminate()
    End Sub




    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'This code snippet illustrates how add custom MetaData to a PDF document
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnAddMetadata_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnAddMetadata.Click
        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\text.pdf"

        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

        Dim pdfDoc As New IacDocument(Nothing)

        pdfDoc.Open(fs, "")
        Try
            'Example: 1 add metadata

            '0: No metadata stream
            '1: Basic XMP metadata  generated by PDF Creator
            '2: Custom metadata stream generated by the calling application
            '3: PDF/A compatible matadata stream (Acrobat 8)
            '4:PDF/A compatible
            Dim attrMetadata As IacAttribute = pdfDoc.AttributeByName("Metadata")
            attrMetadata.Value = 1

            'need to open a file stream to save new PDF document
            'save doc to new file
            Dim fs2 As New FileStream(requiredPath & "\Resulting_Docs\AddMetaData_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)
            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView)
            fs2.Close()
        Catch ev As Exception
            MessageBox.Show(ev.Message)
        End Try

        ListBox1.Items.Add("AddMetaData_resulting.pdf ......... created")

    End Sub


    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'This code snippet illustrates how add custom MetaData to a PDF document
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnMetaData2_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnMetaData2.Click
        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\text.pdf"


        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

        Dim pdfDoc As New IacDocument(Nothing)

        pdfDoc.Open(fs, "")
        Try
            'Example: 2 add custom XML metadata
            '0: No metadata stream
            '1: Basic XMP metadata  generated by PDF Creator
            '2: Custom metadata stream generated by the calling application
            '3: PDF/A compatible matadata stream (Acrobat 8)
            '4:PDF/A compatible

            Dim sb As New StringBuilder()
            sb.Append("<rdf:Description>")
            'starting tag
            sb.Append("<myXLLtag>Amyuni XLM Tag</myXLLtag>")
            sb.Append("</rdf:Description>")
            'ending tag 
            Dim attrMetadata As IacAttribute = pdfDoc.AttributeByName("Metadata")
            attrMetadata.Value = 1

            'Here we are adding custom XML data
            'This is not in our documentation
            Dim attrExtraXmpMetadata As IacAttribute = pdfDoc.AttributeByName("ExtraXMPMetadata")
            attrExtraXmpMetadata.Value = sb.ToString()

            '*******************************************************************

            'need to open a file stream to save new PDF document
            'save doc to new file
            Dim fs2 As New FileStream(requiredPath & "\Resulting_Docs\MetaData2_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)
            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView)


            fs2.Close()
        Catch ev As Exception
            MessageBox.Show(ev.Message)
        End Try

        ListBox1.Items.Add("MetaData2_resulting.pdf ......... created")
    End Sub




    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'This code snippet illustrates how read custom MetaData to a PDF document
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnReadMetaData3_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnReadMetaData3.Click
        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndNameSave As String = requiredPath & "\Resulting_Docs\MetaData2_resulting.pdf"

        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndNameSave, FileMode.Open, FileAccess.Read, FileShare.Read)

        Dim pdfDoc As New IacDocument(Nothing)

        pdfDoc.Open(fs, "")
        Try
            'This returns the Metadata embeded in the document
            'This will also return an metadata added by ExtraXMPMetadata attribute
            MessageBox.Show(pdfDoc.AttributeByName("MetadataStream").Value.ToString())

            'This returns metadata added by ExtraXMPMetadata attribute only

            MessageBox.Show(pdfDoc.AttributeByName("ExtraXMPMetadata").Value.ToString())
        Catch ev As Exception
            MessageBox.Show(ev.Message)
        End Try
    End Sub


    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The StartPrint method starts printing the document to a specified printer. This method is used to start the printing
    'process and takes the same parameters as the Print method.
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnPrint_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnPrint.Click
        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()

        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\CreateTextObject.pdf"

        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

        'need to create a document object
        Using doc As New IacDocument(Nothing)
            Try
                'Open the document
                doc.Open(fs, "")

                'Start printing document
                'If no printer name is specified, the document is printed to the default printer.
                doc.StartPrint("HP LaserJet P2035n", False)

                'Print Page by Page
                For pageIndex As Integer = 1 To doc.PageCount
                    doc.CurrentPage = doc.GetPage(pageIndex)
                    doc.PrintPage(doc.GetPage(pageIndex))
                Next


                fs.Close()

                'Stop printing

                doc.EndPrint()
            Catch ev As Exception
                MessageBox.Show(ev.Message)


            End Try
        End Using

        'end and cleanup
        'this should only be done once when your app terminates
        acPDFCreatorLib.Terminate()
    End Sub



    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The Print method is used to print the document to a specified printer.
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnPrintDocument_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnPrintDocument.Click
        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()

        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\CreateTextObject.pdf"

        'need to open a file stream 
        Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

        'need to create a document object
        Using doc As New IacDocument(Nothing)
            Try

                doc.Open(fs, "")


                'Parameters
                '      PrinterName
                'If no printer name is specified, the document is printed to the default printer.
                '      Prompt
                'If this parameter is set to True, the user is prompted with the printer selection dialog box.


                'Check if it password protected
                If doc.[Protected] = 1 Then

                    'check if print is enabled
                    If IacCommandToolStatus.acCommandToolStatusEnabled = doc.UpdateCommandTool(IacCommandTool.acCommandToolPrint) Then

                        MessageBox.Show($"doc encypted and printing disabled")
                    Else
                        doc.Print("", False)
                    End If

                End If
            Catch ev As Exception
                MessageBox.Show(ev.Message)

            End Try
        End Using

        'end and cleanup
        'this should only be done once when your app terminates
        acPDFCreatorLib.Terminate()
    End Sub


    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The ExportToJPeg method is used to export a PDF document to multiple JPEG files. It is recommended to use this
    'method together with the OptimizeDocument method
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnExporttoJpeg_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnExporttoJpeg.Click
        Try

            'set license key 
            acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

            '/get startup path for temp working files
            Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

            ' Open the PDF document file.
            Dim strFilePathAndName As String = requiredPath & "\Source_Docs\text.pdf"

            'Open file-steam
            Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

            Dim pdfDoc As New IacDocument(Nothing)

            pdfDoc.Open(fs, "")

            '  'No optimization 0
            '                    'Line optimization (Recommended) 1
            '                    'Paragraph optimization 2
            '                

            pdfDoc.OptimizeDocument(1)


            ' Resulting JPG file.
            Dim strFilePathAndNameJepg As String = requiredPath & "\Resulting_Docs\ExportToJpeg_resulting.jpg"

            'export the PDF file to JPEG format with the resoluction=300 and compression level=5.
            pdfDoc.ExportToJPeg(strFilePathAndNameJepg, 300, 5)


        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

        ListBox1.Items.Add("ExportToJpeg_resulting.jpg ...... created")
    End Sub


    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The ExportToXPS method is used to export a PDF document to XPS format.
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnExporttoXPS_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnExporttoXPS.Click
        Try
            'initailize library
            'This should be done once
            acPDFCreatorLib.Initialize()

            'set license key 
            acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

            '/get startup path for temp working files
            Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

            ' Open the PDF document file.
            Dim strFilePathAndName As String = requiredPath & "\Source_Docs\text.pdf"


            'Open file-steam
            Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

            Dim pdfDoc As New IacDocument(Nothing)

            pdfDoc.Open(fs, "")

            '  'No optimization 0
            '  'Line optimization (Recommended) 1
            '  'Paragraph optimization 2
            '                

            pdfDoc.OptimizeDocument(0)


            ' Resulting XPS file.
            Dim strFilePathAndNameXps As String = requiredPath & "\Resulting_Docs\ExportToXps_resulting.xps"

            'export the PDF file to Xps
            pdfDoc.ExportToXPS(strFilePathAndNameXps, IacXPSExportOptions.acXPSExportOptionsNone)

            fs.Close()
            pdfDoc.Dispose()


            acPDFCreatorLib.Terminate()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

        ListBox1.Items.Add("ExportToXps_resulting.xps ...... created")
    End Sub



    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The ExportToTiff method is used to export a PDF document to a single TIFF file. It is recommended to use this
    'method together with the OptimizeDocument method
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnExportToTiff_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnExportToTiff.Click
        'Initialize PDF Creator Lib
        acPDFCreatorLib.Initialize()
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)


        Dim tiffFormat As UInteger = 10
        Dim tiffResolution As UInteger = 100

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\text.pdf"

        Dim fs As New FileStream(strFilePathAndName, FileMode.Open)
        Dim document As New IacDocument(Nothing)
        document.OpenEx(fs, "")

        '  'No optimization 0
        '                'Line optimization (Recommended) 1
        '                'Paragraph optimization 2
        '            

        document.OptimizeDocument(1)

        ' Resulting TIFF file.
        Dim strFilePathAndNameTiff As String = requiredPath & "\Resulting_Docs\btnTiff_resulting.tiff"

        'export the PDF file to JPEG format with the resoluction=300 and compression level=5.
        document.ExportToTiff(strFilePathAndNameTiff, tiffResolution, tiffFormat)

        document.Dispose()
        fs.Close()

        ListBox1.Items.Add("btnTiff_resulting.tiff ....... created")
    End Sub


    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The ExportToHTML method is used to export a PDF document to HTML format. It is recommended to use this method
    'together with the OptimizeDocument method
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnPDFtoHTML_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnPDFtoHTML.Click

        Try
            acPDFCreatorLib.Initialize()

            'set license key 
            '2 page limit on export
            acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

            '/get startup path for temp working files
            Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

            ' Open the PDF document file.
            Dim strFilePathAndName As String = requiredPath & "\Source_Docs\text.pdf"


            'Open file-steam
            Dim fs As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

            Dim pdfDoc As New IacDocument(Nothing)

            pdfDoc.Open(fs, "")

            '//////////////////////////////////////////////////////////////////
            'Optimization level to apply to PDF document before exporting to Excel.
            'No optimization 0
            'Line optimization (Recommended) 1
            'Paragraph optimization 2
            'optimize document to line level before exporting


            pdfDoc.OptimizeDocument(1)


            '//////////////////////////////////////////////////////////////
            'Options
            ' Use Layers: Multiple pages in a single HTML file using layers 0001
            ' Single HTML: All pages in a single HTML file 0002
            ' Multiple HTML files: Each page in a separate HTML file 0003
            ' VectorGraphics



            ' Resulting HTML file.
            'export the PDF file to HTML format
            pdfDoc.ExportToHTML(requiredPath & "\Resulting_Docs\PDFtoHTML_resulting.htm", IacHtmlExportOption.acHtmlExportOptionSinglePage)
            fs.Close()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

        ListBox1.Items.Add("PDFtoHTML_resulting.htm ....... created")
    End Sub



    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ' This code snippet illustrates how to save an XPS document as a PDF document
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnXPStoPDF_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnXPStoPDF.Click
        acPDFCreatorLib.Initialize()
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the XPS document file.
        Dim strFilePathAndName As String = requiredPath & "\Source_Docs\webpage.xps"


        Dim file1 As New FileStream(strFilePathAndName, FileMode.Open, FileAccess.Read, FileShare.Read)

        Dim document As New IacDocument(Nothing)
        document.OpenEx(file1, "")

        ' Resulting PDF file.

        File.Delete(requiredPath & "\Resulting_Docs\Xps2PDF_resulting.pdf")
        Dim output As New FileStream(requiredPath & "\Resulting_Docs\Xps2PDF_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)

        Try
            document.Save(output, IacFileSaveOption.acFileSaveView)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
        output.Close()
        file1.Close()

        acPDFCreatorLib.Terminate()

        ListBox1.Items.Add("Xps2PDF_resulting.pdf ...... created")
    End Sub


    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The Merge method merges the contents of the current document into a specified PDF file.
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnMergeDocs_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnMergeDocs.Click
        ' Open the PDF document file.
        acPDFCreatorLib.Initialize()
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        Dim strFilePathAndNameFileOne As String = requiredPath & "\Source_Docs\text.pdf"
        Dim strFilePathAndNameFileTwo As String = requiredPath & "\Source_Docs\logo.pdf"

        ' Open the first PDF document from file
        Dim file1 As New FileStream(strFilePathAndNameFileOne, FileMode.Open, FileAccess.Read)
        Dim pdfDoc1 As New IacDocument(Nothing)
        pdfDoc1.Open(file1, "")


        ' Open the second PDF document from file
        Dim file2 As New FileStream(strFilePathAndNameFileTwo, FileMode.Open, FileAccess.Read)
        Dim pdfDoc2 As New IacDocument(Nothing)
        pdfDoc2.Open(file2, "")


        ' merge the two documents
        pdfDoc1.Merge(pdfDoc2, 1)

        'need to open a file stream to save new PDF document

        ' save the result to a third file
        Dim file3 As New FileStream(requiredPath & "\Resulting_Docs\Merge_resulting.pdf", FileMode.Create, FileAccess.Write)
        pdfDoc1.Save(file3)


        ListBox1.Items.Add("Merge_resulting.pdf .............. created")

    End Sub


    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The Append method can be used to append or concatenate a PDF file to the current document
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnAppendDocs_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnAppendDocs.Click
        'initailize library
        'This should be done once
        acPDFCreatorLib.Initialize()

        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        Dim strFilePathAndNameFileOne As String = requiredPath & "\Source_Docs\text.pdf"
        Dim strFilePathAndNameFileTwo As String = requiredPath & "\Source_Docs\logo.pdf"


        ' Open the first PDF document from file
        Dim file1 As New FileStream(strFilePathAndNameFileOne, FileMode.Open, FileAccess.Read)
        Dim pdFdoc1 As New IacDocument(Nothing)
        pdFdoc1.Open(file1, "")


        ' Open the second PDF document from file
        Dim file2 As New FileStream(strFilePathAndNameFileTwo, FileMode.Open, FileAccess.Read)
        Dim pdFdoc2 As New IacDocument(Nothing)
        pdFdoc2.Open(file2, "")

        'append the two documents
        pdFdoc1.Append(pdFdoc2)
        file1.Close()


        'Option #1
        'reopen file stream and save
        'System.IO.FileStream filex = new System.IO.FileStream(strFilePathAndNameFileOne, FileMode.Open, FileAccess.ReadWrite);
        'PDFdoc1.Save(filex, IacFileSaveOption.acFileSaveView);


        'Option #2
        'Open the PDF document file.

        'save doc to new file
        'save the result to a third file
        Dim file3 As New FileStream(requiredPath & "\Resulting_Docs\AppendDocs_resulting.pdf", FileMode.Create, FileAccess.Write)
        pdFdoc1.Save(file3)

        ListBox1.Items.Add("AppendDocs_resulting.pdf .......... created")
    End Sub



    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    'The DigitalSignature method is used to add a digital signature to a PDF document. Prior to digitally signing a
    'document, the users or developers should have on their systems a digital certificate that can be used to sign
    'documents. A user who receives a document that is digitally signed can verify if the digital signature is valid and if the
    'document has been tempered with.
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnDigitalSignature_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnDigitalSignature.Click
        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        'need to open a file stream 
        Dim fs As New FileStream(requiredPath & "\Source_Docs\text.pdf", FileMode.Open, FileAccess.Read, FileShare.Read)

        Dim pdfDoc As New IacDocument(Nothing)

        pdfDoc.Open(fs, "")
        Try
            '***************************************************************
            'FLAGS
            '====================
            '0: Hidden Signature
            '1: Signer Name
            '2: Reason for signing
            '4: Location
            '8: Associated Image
            '32: Date of signing
            '64: Signature type
            '255: Show All 
            '====================

            pdfDoc.DigitalSignature("John Smith", "My Reason", requiredPath & "\Source_Docs\sign.jpg", "Montreal", 1, 0,
             0, 2000, 2000, 255)

            '*******************************************************************

            ' Open the PDF document file.
            'save doc to new file
            Dim fs2 As New FileStream(requiredPath & "\Resulting_Docs\DigitalSignature_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)


            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView)
        Catch ev As Exception
            MessageBox.Show(ev.Message)
        End Try

        ListBox1.Items.Add("DigitalSignature_resulting.pdf ...... created")
    End Sub



    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ' This code snippet illustrates how to add a bookmark to an existing PDF document
    '///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    Private Sub btnBookmarks_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnBookmarks.Click
        'set license key 
        acPDFCreatorLib.SetLicenseKey(LicenseTo, ActivationCode)

        '/get startup path for temp working files
        Dim requiredPath As String = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(
                                                    Path.GetDirectoryName(
                                                    Assembly.GetExecutingAssembly().Location))))

        ' Open the PDF document file.
        'need to open a file stream 
        Dim fs As New FileStream(requiredPath & "\Source_Docs\tenpages.pdf", FileMode.Open, FileAccess.Read, FileShare.Read)

        Dim pdfDoc As New IacDocument(Nothing)

        pdfDoc.Open(fs, "")
        Try
            Dim bookmarkPageNumber As Integer = 1
            Dim bookmarkNumber As Integer = 1
            pdfDoc.CurrentPage = pdfDoc.GetPage(bookmarkPageNumber)

            pdfDoc.RootBookmark.InsertChild(bookmarkNumber, "text", "")

            ' Save file.
            Dim fs2 As New FileStream(requiredPath & "\Resulting_Docs\Bookmarks_resulting.pdf", FileMode.Create, FileAccess.Write, FileShare.Read)


            pdfDoc.Save(fs2, IacFileSaveOption.acFileSaveView)
        Catch ev As Exception
            MessageBox.Show(ev.Message)
        End Try

        ListBox1.Items.Add("Bookmarks_resulting.pdf ....... created")
    End Sub
End Class
